﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;
//
// Image Form1 2019.1.26
//

namespace Img
{
    public partial class Form1 : Form
    {

        int crt_width, crt_height;

        int PX=0, PY=0;

        int ImgW, ImgH,Mh;
        //      int Sx,Sy,PboxX, PboxY;
        string fname, filname, path, filname1;

 
        private void File_Loard()
        {
            try
            {
                pictureBox1.Image = Image.FromFile(fname);
                Mh = SystemInformation.MenuHeight;
                ImgW = pictureBox1.Image.Width;
                ImgH = pictureBox1.Image.Height;
                float r = (float)ImgW / (float)ImgH;

                if (ImgW > 1000)
                {
                    Width = crt_width * 2 / 3;

                    Height = (int)(Width / r) + 70;
                    if (Height > crt_height)
                    {
                        Height = crt_height - 100;
                    }
                    panel1.Width = Width - 30;
                    panel1.Height = Height - 70;
                    panel1.Left = 10;
                    panel1.Top = Mh + 4;
                    //    panel1.AutoScrollPosition = new Point(0, 0);
                    panel1.AutoScrollPosition = new Point(panel1.AutoScrollPosition.X + PX, panel1.AutoScrollPosition.Y + PY);


                }
                else
                {
                    Width = ImgW + 40;
                    Height = (int)(Width / r) + 70;
                    panel1.Width = Width;
                    panel1.Height = Height;
                    panel1.Left = 0;

                }



            }
            catch (Exception)
            {
                Clipboard.Clear();
                Close();
            }

        }

        private void Disp_L2()
        {

            {
                //     label2.Text = panel1.Width.ToString() + " * " + panel1.Height.ToString();
                label2.Text = ImgW.ToString() + " * " + ImgH.ToString();
            }
        }
        private void jpegAnalToolStripMenuItem_Click(object sender, EventArgs e)
        {
          string path = Application.ExecutablePath;
          path = Path.GetDirectoryName(path) + "\\" + "JpegAna1\\JpegAnalyzer.exe";
          System.Diagnostics.Process.Start(path, fname);
                        
        }

        private void previewToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Bitmap bmp = (Bitmap)pictureBox1.Image;

            DataObject data = new DataObject();

            data.SetData(fname);
            data.SetData(bmp);
            Clipboard.SetDataObject(data, true);



            Form2 f = new Form2();

            f.ShowDialog(this);
                
                
            if (f.MFLG == 255)
            {
                PX = f.X0;
                PY = f.Y0;
                panel1.AutoScrollPosition = new Point(0, 0);
                panel1.AutoScrollPosition = new Point(panel1.AutoScrollPosition.X + PX, panel1.AutoScrollPosition.Y + PY);

            }
        }

        public Form1()
        {
            InitializeComponent();
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void openToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                fname = openFileDialog1.FileName;
            }
            if (fname != "")
            {
                File_Loard();
            }
        }


        private void inputToolStripMenuItem_Click_1(object sender, EventArgs e)
        {
            Form3 f3 = new Form3();
            f3.W3 = pictureBox1.Image.Width;
            f3.H3 = pictureBox1.Image.Height;


            f3.ShowDialog(this);

            if(f3.W3==0)
            {
                return;
            }
            int w = f3.W3;
            int h = f3.H3;

            Bitmap bmp = new System.Drawing.Bitmap(fname);
            Bitmap canvas = new Bitmap(w, h);

            Graphics g = Graphics.FromImage(canvas);
            Rectangle rect = new Rectangle(0, 0, w, h);

            g.DrawImage(bmp, rect);

            pictureBox1.Image = canvas;

            panel1.Width = Width - 30;
            panel1.Height = Height - 70;
            panel1.Left = 10;
            panel1.Top = Mh + 4;
            //    panel1.AutoScrollPosition = new Point(0, 0);
            panel1.AutoScrollPosition = new Point(panel1.AutoScrollPosition.X + PX, panel1.AutoScrollPosition.Y + PY);

            縮小の取り消しToolStripMenuItem.Enabled = true;
        }

        private void 縮小の取り消しToolStripMenuItem_Click(object sender, EventArgs e)
        {
            File_Loard();
            縮小の取り消しToolStripMenuItem.Enabled = false;

        }

        private void saveFileToolStripMenuItem_Click(object sender, EventArgs e)//file
        {


            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                filname = saveFileDialog1.FileName;

                filname1 = System.IO.Path.GetFileNameWithoutExtension(filname);
                path= System.IO.Path.GetDirectoryName(filname);

                filname = path + "\\" + filname1 + ".jpg";
            }
            else
            {
                return;
            }
                
            Bitmap bmp = new Bitmap(panel1.Width, panel1.Height);

            Graphics g = Graphics.FromImage(bmp);

            //  Bitmap img = new Bitmap(fname);
            Bitmap img =(Bitmap) pictureBox1.Image;

            Point pos = panel1.AutoScrollPosition;
            pos.X = pos.X * -1;
            pos.Y = pos.Y * -1;
            Rectangle srcRect = new Rectangle(pos.X, pos.Y, panel1.Width, panel1.Height);

            Rectangle dstRect = new Rectangle(0, 0, panel1.Width, panel1.Height);

            g.DrawImage(img, dstRect, srcRect, GraphicsUnit.Pixel);  //左上の座標、幅、高さ
            g.Dispose();

           if(System.IO.File.Exists(filname))
            {
                try
                {
                    System.IO.File.Delete(filname);
                }
                catch(Exception)
                {
                    MessageBox.Show("現在使用中のフアイルでSave出来ません","警告", MessageBoxButtons.OK);

                    return;
                }

            }

            bmp.Save(filname, System.Drawing.Imaging.ImageFormat.Jpeg);
            MessageBox.Show("保存しました");
         
        }

        private void clipBoardToolStripMenuItem_Click(object sender, EventArgs e) //clipboard
        {
            Bitmap bmp = new Bitmap(panel1.Width, panel1.Height);

            Graphics g = Graphics.FromImage(bmp);

            // Bitmap img = new Bitmap(fname);
            Bitmap img = (Bitmap)pictureBox1.Image;

            Point pos = panel1.AutoScrollPosition;
            pos.X = pos.X * -1;
            pos.Y = pos.Y * -1;
            Rectangle srcRect = new Rectangle(pos.X, pos.Y, panel1.Width, panel1.Height);

            Rectangle dstRect = new Rectangle(0, 0, panel1.Width, panel1.Height);

            g.DrawImage(img, dstRect, srcRect, GraphicsUnit.Pixel);  //左上の座標、幅、高さ
            g.Dispose();


            Clipboard.SetImage(bmp);

            MessageBox.Show("ClipBoardに保存しました");


        }

        private void openToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Clipboard.Clear();
            Close();
        }


        private void Form1_Load(object sender, EventArgs e)
        {
            crt_width = Screen.PrimaryScreen.Bounds.Width;
            crt_height = Screen.PrimaryScreen.Bounds.Height;

            if (Clipboard.ContainsText())
            {
         
                string[] s;
                string d = Clipboard.GetText();
                s = d.Split(',');
                fname = s[0];
               try
                {
                    PX = int.Parse(s[1]);
                    PY = int.Parse(s[2]);
                }
                catch (Exception)
                {
                    ;
                }

                fname = fname.ToLower();

                if ( (fname.Contains("jpg")) || (fname.Contains("bmp"))|| (fname.Contains("png")))
                {
                    ;
                }
                else
                {
                    if (openFileDialog1.ShowDialog() == DialogResult.OK)
                    {
                        fname = openFileDialog1.FileName;
                    }

                }
            }
            else
            {
                if (openFileDialog1.ShowDialog() == DialogResult.OK)
                {
                    fname = openFileDialog1.FileName;
                }


            }
            if (fname != "")
            {
                File_Loard();
            }

            this.Left = 100;
            this.Top = 50;

            label1.Text = fname;
            pictureBox1.ContextMenuStrip = contextMenuStrip1;

            label1.Left = 250;
            label1.Top = 5;

            label2.Left = 180;
            label2.Top = 5;

        }



        private void Form1_Resize(object sender, EventArgs e)
        {
            panel1.Width = Width - 30;
            panel1.Height = Height - 70;
            panel1.Left = 10;
            panel1.Top = Mh+4;

            Disp_L2();
        }
    }
  
}
